<?php
/**
 *       @file  qtrStats.php
 *      @brief  This module contains investigation statistics
 *
 *     @author  Quttera (qtr), contactus@quttera.com
 *
 *   @internal
 *     Created  01/14/2016
 *    Compiler  gcc/g++
 *     Company  Quttera
 *   Copyright  Copyright (c) 2016, Quttera
 *
 * This source code is released for free distribution under the terms of the
 * GNU General Public License as published by the Free Software Foundation.
 * =====================================================================================
 */

define( 'QTR_STATS','quttera_wp_stats');

require_once('qtrOptions.php');

class CQtrStats
{
    protected $_stats;

    public function __construct()
    {
        $this->_stats = array();
        $this->_LoadStats();
    }

    public function Reset()
    {
        $this->_stats = array();
        $this->_stats["TOTAL"]          = 0;
        $this->_stats["CLEAN"]          = 0;
        $this->_stats["SUSPICIOUS"]     = 0;
        $this->_stats["POT_SUSPICIOUS"] = 0;
        $this->_stats["MALICIOUS"]      = 0;
        $this->_stats["START_TIME"]     = time();
        $this->_StoreStats();
        return TRUE;
    }


    public function Get()
    {
        $this->_LoadStats();
        return $this->_stats;
    }


    public function IncTotal()
    {
        return $this->_Inc("TOTAL");
    }


    public function IncClean()
    {
        $this->IncTotal();
        return $this->_Inc("CLEAN");
    }

    public function IncSusp()
    {
        $this->IncTotal();
        return $this->_Inc("SUSPICIOUS");
    }

    public function IncPotSusp()
    {
        $this->IncTotal();
        return $this->_Inc("POT_SUSPICIOUS");
    }

    public function IncMalicious()
    {
        $this->IncTotal();
        return $this->_Inc("MALICIOUS");
    }

    public function Increment($severity){

        $sev = strtolower($severity);

        if(strpos($sev,"malicious") !== FALSE )
        {
            return $this->IncMalicious();
        }        
        else if(strpos($sev,"pot") !== FALSE )
        {
            return $this->IncPotSusp();
        }
        else if(strpos($sev,"susp") !== FALSE )
        {
            return $this->IncSusp();
        }
        return $this->IncClean();
    }

    public function Total($v=NULL){
        if( is_int($v) ){
            $this->_stats["TOTAL"] = $v;
        }
        return $this->_stats["TOTAL"];
    }

    public function Clean($v=NULL){
        if( is_int($v) ){
            $this->_stats["CLEAN"] = $v;
        }
        return $this->_stats["CLEAN"];
    }

    public function Suspicious($v=NULL){
        if( is_int($v) ){
            $this->_stats["SUSPICIOUS"] = $v;
        }
        return $this->_stats["SUSPICIOUS"];
    }

    public function PotSuspicious($v=NULL){
        if( is_int($v) ){
            $this->_stats["POT_SUSPICIOUS"] = $v;
        } 
        return $this->_stats["POT_SUSPICIOUS"];
    }

    public function Malicious($v=NULL){
        if( is_int($v) ){
            $this->_stats["MALICIOUS"] = $v;
        }
        return $this->_stats["MALICIOUS"];
    }

    public function StartTime(){
        return $this->_stats["START_TIME"];
    }

    public function GetCounters(){
        return $this->_stats;
    }

    /******************************************************
     *
     *      PROTECTED METHODS 
     *
     *****************************************************/
    protected function _LoadStats(){
        $body   = CQtrOptions::GetOption ( QTR_STATS );
        if( $body ){
            $this->_stats = CQtrOptions::Unserialize( $body );
            if( !is_array( $this->_stats ) ){
                /* 
                 * something gone wrong, reset statistics
                 */
                $this->Reset();
            }
        }else{
            /*
             * nothing found
             */
            $this->Reset();
        }

        return TRUE;
    }

    protected function _StoreStats(){
        $body = CQtrOptions::Serialize( $this->_stats );

        if ( CQtrOptions::GetOption( QTR_STATS ) !== false ) 
        {
            $rc = CQtrOptions::UpdateOption( QTR_STATS , $body );
            return $rc;
        }
        else 
        {
            $deprecated = null;
            $autoload = 'no';
            return CQtrOptions::AddOption( QTR_STATS , $body ,$deprecated, $autoload );
        }
    }   


    protected function _Inc($name)
    {
        if( isset($this->_stats[$name]) )
        {
            $this->_stats[$name] = intval($this->_stats[$name]) + 1;
        }
        else
        {
            $this->_stats[$name] = 1;
        }

        $this->_StoreStats();
        return $this->_stats[$name];
    }
}

?>
